package furny.swing.admin.tags;

import java.awt.datatransfer.DataFlavor;

import furny.entities.Tag;

/**
 * {@link DataFlavor} for tags. (for drag and drop)
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class TagFlavor extends DataFlavor {

  /**
   * Instantiates a new tag flavor.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public TagFlavor() {
    super(Tag.class, DataFlavor.javaJVMLocalObjectMimeType + ";class=IdList");
  }

  @Override
  public boolean equals(final Object o) {
    return super.equals(o) && o instanceof TagFlavor;
  }

  @Override
  public boolean equals(final DataFlavor that) {
    return super.equals(that) && that instanceof TagFlavor;
  }

  @Override
  public int hashCode() {
    return getHumanPresentableName().hashCode();
  }
}
